import { observer } from "mobx-react";
import React, { useEffect, useRef } from "react";
import './index.less'

/**
 * 返回在页面中真实的 px 值
 * @param {Number} designSize 设计稿上的像素值
 * @returns 
 */
function getTruthPx(designSize) {
  const remUnit = parseFloat(document.documentElement.style.fontSize)
  return designSize / 100 * remUnit
}

const Circel = ({ precent, className, lineWidth = 10, width = 300, height = 300, color = '#ffffff' }) => {
  const num = 0
  const ctx = useRef(null)
  const leftCircelWrpStyle = {
    width: `${width / 100 / 2}rem`,
    height: `${height / 100}rem`,
    borderRadius: `${width / 100}rem 0 0  ${width / 100}rem`,
    // left: `${width / 100 / 2}rem`,
  }
  const leftCircelStyle = {
    ...leftCircelWrpStyle,
    background: color,
  }
  const rightCircelWrpStyle = {
    width: `${width / 100 / 2}rem`,
    height: `${height / 100}rem`,
    borderRadius: `0 ${width / 100}rem ${width / 100}rem 0`,
    left: `${width / 100 / 2}rem`,
  }
  const rightCircelStyle = {
    ...rightCircelWrpStyle,
    left: 0,
    background: color,
  }
  return <div className={"circel-wrp " + className}>
    <div className="mid-circel">
      <div className="left-circel-wrp" style={leftCircelWrpStyle}>
        <div style={leftCircelStyle} className="left-circel"></div>
      </div>
      <div className="right-circel-wrp" style={rightCircelWrpStyle}>
        <div style={rightCircelStyle} className="right-circel"></div>
      </div>
      <div className="con-circel"></div>
    </div>
    <div className="circel-circel"></div>
  </div>
}

export default observer(Circel)